 ; Ŀ
 ;   Bubba - Flip an attribute between centre and middle justification.    
 ;   Also move the new insertion point to where the old one was.           
 ;   Copyright 2008 by Rocket Software Ltd.                                
 ;                                                                         
 ; 

 ; Ŀ
 ;   Justx - returns a string describing the justification of the text     
 ;   entity whose data was passed as its sole argument.                    
 ; 
 (DEFUN JUSTX (entt / xjust yjust xjst yjst justrg)
  (setq xjust (cdr (assoc 72 entt)))
  (if (= (cdr (assoc 0 entt)) "TEXT")
      (setq yjust (cdr (assoc 73 entt)))
      (setq yjust (cdr (assoc 74 entt))))
 ; Ŀ
 ;   Vertical justification.                                               
 ; 
  (cond ((= yjust 0) (setq yjst ""))       ; base = normal
        ((= yjust 1) (setq yjst "B"))      ; bottom
        ((= yjust 2) (setq yjst "M"))      ; middle
        ((= yjust 3) (setq yjst "T"))      ; top
        (T           (setq yjst "")))      ; default
 ; Ŀ
 ;   Horizontal justification.                                             
 ; 
  (cond ((= xjust 0) (setq xjst "L"))      ; left
        ((= xjust 1) (setq xjst "C"))      ; centre
        ((= xjust 2) (setq xjst "R"))      ; right
        ((= xjust 3) (setq xjst "A"))      ; aligned
        ((= xjust 4) (setq xjst "M"))      ; middle
        ((= xjust 5) (setq xjst "F"))      ; fit
        (T           (setq xjst "L")))     ; default
  (setq justrg (strcat yjst xjst)))
 ; Ŀ
 ;   Justx end.                                                            
 ; 

 ; Ŀ
 ;   Bubba.                                                                
 ; 
 (DEFUN C:BUBBA (/ osmo snapp *error* enam nent typ entt outer justa)
  (setvar "cmdecho" 0)
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (setvar "snapmode" snapp)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Get an attribute.                                                     
 ; 
  (setq enam (car (setq nent (nentsel "Attribute to move: "))))
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
  (if (or (= "TEXT" typ) (= "ATTDEF" typ) (= "ATTRIB" typ))
      (progn
           (setq outer (car (reverse (car (reverse nent)))))
           (setq justa (justx entt))
           (cond ((= justa "C")
                  (entmod (subst (cons 72 4) (assoc 72 entt) entt)))
                 ((= justa "M")
                  (entmod (subst (cons 72 1) (assoc 72 entt) entt)))
                 (t (prompt "Useless alignment.  No change made.")))
           (cond ((= (type outer) 'ENAME)
                  (entupd outer))
                 ((= typ "ATTRIB")
                  (entupd (cdr (assoc 330 entt)))))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))